/**
 * @fileoverview JSLint XML reporter
 * @author Ian Christian Myers
 */
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = __importDefault(require("lodash"));
//------------------------------------------------------------------------------
// Public Interface
//------------------------------------------------------------------------------
function formatter(results) {
    let output = "";
    output += '<?xml version="1.0" encoding="utf-8"?>';
    output += "<jslint>";
    results.forEach(function (result) {
        const messages = result.messages;
        output += `<file name="${result.filePath}">`;
        messages.forEach(function (message) {
            output +=
                `<issue line="${message.line}" ` +
                    `char="${message.column}" ` +
                    // TODO: evidence is always empty string
                    // See: https://github.com/textlint/textlint/issues/400
                    `evidence="" ` +
                    `reason="${lodash_1.default.escape(message.message || "")}${message.ruleId ? ` (${message.ruleId})` : ""}" />`;
        });
        output += "</file>";
    });
    output += "</jslint>";
    return output;
}
exports.default = formatter;
//# sourceMappingURL=jslint-xml.js.map